//
//  ViewController.swift
//  Route Map Direction
//
//  Created by Bhavin Chauhan on 02/05/22.
//

import UIKit
import GoogleMaps
import CoreLocation
import GoogleMapsUtils
import MapKit

struct route: Decodable {
    var route: [routeObj]
}

class routeObj: Decodable {
    var latitude: Double?
    var longitude: Double?
    var track_ts: String?
    var location_short: String?
    var batterylevel: Int?
    var accuracy: Double?
}

class ViewController: UIViewController,CLLocationManagerDelegate {

    @IBOutlet var countDownLabel: UILabel!
    var count : Int = 0
    var timerCountDown : Timer?

    var locationManager = CLLocationManager()
    var coordinate = CLLocationCoordinate2D()
    var bound = GMSCoordinateBounds()

    var arrRouteMap : [routeObj] = [routeObj]()
    let path = GMSMutablePath()
    var playMarker = GMSMarker()
    let polylines = GMSPolyline()


    var points: [CLLocationCoordinate2D] = []
    
    var currentSession : Int = 0

    @IBOutlet var mapView: GMSMapView!
    @IBOutlet var dateHolderView: UIView!
    @IBOutlet var dateLabel: UILabel!
    @IBOutlet var container: UIView!
    @IBOutlet var pauseButton: UIButton!
    @IBOutlet var slider: UISlider!
    @IBOutlet var closeButton: UIButton!
    
    var isSliderMoving = false

    var currentCount: Int = 0 {
        didSet {
            DispatchQueue.main.async { [self] in
                if self.currentCount <= self.totalCount {
                    if !isSliderMoving{
                        self.slider.setValue(Float(self.currentCount), animated: true)
                    }else{
                        //self.slider.setValue(Float(self.currentCount), animated: false)
                    }
                }else{
                    self.slider.setValue(0, animated: true)
                }
            }
        }
    }
    
    var totalCount : Int = 0
    
    override func viewDidLoad() {
        super.viewDidLoad()

            polylines.strokeWidth = 2.0
            polylines.strokeColor = .blue
        
            arrRouteMap.append(contentsOf: self.loadJson(filename: "map") ?? [])
            arrRouteMap.append(contentsOf: self.loadJson(filename: "map") ?? [])
            arrRouteMap.append(contentsOf: self.loadJson(filename: "map") ?? [])
            arrRouteMap.append(contentsOf: self.loadJson(filename: "map") ?? [])
//            arrRouteMap.append(contentsOf: self.loadJson(filename: "map") ?? [])
//            arrRouteMap.append(contentsOf: self.loadJson(filename: "map") ?? [])
//            arrRouteMap.append(contentsOf: self.loadJson(filename: "map") ?? [])
//            arrRouteMap.append(contentsOf: self.loadJson(filename: "map") ?? [])

            self.startTimer()
        
    }

    @objc func update() {
        count += 1
        if(count > 0){
            let minutes = String(count / 60)
            let seconds = String(count % 60)
            DispatchQueue.main.async {
                self.countDownLabel.text = minutes + ":" + seconds
            }
            
        }

    }
    
    
    var timer: Timer?
    
    private func  startTimer() {
        
        totalCount = arrRouteMap.count - 1
    
        slider.minimumValue = 0
        slider.maximumValue = Float(arrRouteMap.count - 1)
        slider.setValue(0.0, animated: true)
        
        self.playMarker.icon = UIImage(named: "ic_marker_Circle")
        self.playMarker.map = self.mapView
        self.polylines.map = self.mapView

        DispatchQueue.main.async { [self] in
            
            //timeTriggered()
            timer = Timer.scheduledTimer(timeInterval: 10.0 / Double(self.totalCount), target: self, selector: #selector(timeTriggered), userInfo: nil, repeats: true)
            
            timerCountDown = Timer.scheduledTimer(timeInterval: 1.0, target: self, selector: #selector(update), userInfo: nil, repeats: true)
        
            
        }
        
    }
    
    @objc func timeTriggered() {

    if currentCount <= self.totalCount {
        print(currentCount)
        trackingMap()
        currentCount += 1
        
        } else {
  
            self.timer?.invalidate()
            self.timer = nil
            
            self.timerCountDown?.invalidate()
            self.timerCountDown = nil
            self.count = 0
            
            self.currentSession += 1
            
            self.slider.minimumValue = Float(0)
            self.slider.maximumValue = Float(totalCount)
            self.currentCount = 0
 
            }
            
        }
    
    func trackingMap(){
        
        let latitude = arrRouteMap[currentCount].latitude ?? 0.0
        let longitude = arrRouteMap[currentCount].longitude ?? 0.0
        let timeStamp = arrRouteMap[currentCount].track_ts ?? ""

        //Polyline Genrator
        self.path.addLatitude(latitude, longitude: longitude)
        polylines.path = self.path
        
        //Marker Moving
        //let position = CLLocationCoordinate2D(latitude: latitude, longitude: longitude)
        self.playMarker.position = path.coordinate(at: path.count()-1)

        bound = bound.includingCoordinate(path.coordinate(at: path.count()-1))

        DispatchQueue.main.async { [self] in
            //self.mapView.animate(with: GMSCameraUpdate.fit(bound))
 
        self.mapView.animate(with: GMSCameraUpdate.fit(bound, withPadding: 140.0))
            
        self.dateLabel.text = timeStamp
        self.dateHolderView.isHidden = false
        self.dateLabel.isHidden = false
            
        CATransaction.begin()
        CATransaction.setValue(1.5, forKey: kCATransactionAnimationTimingFunction)
        CATransaction.commit()
        }
        
    }

    func loadJson(filename fileName: String) -> [routeObj]? {
        if let url = Bundle.main.url(forResource: fileName, withExtension: "json") {
            do {
                let data = try Data(contentsOf: url)
                let decoder = JSONDecoder()
                let jsonData = try decoder.decode(route.self, from: data)
                return jsonData.route
            } catch {
                print("error:\(error)")
            }
        }
        return nil
    }

   
    @IBAction func btnClose(_ sender: Any) {
        
        self.path.removeAllCoordinates()
        self.mapView.clear()
        self.polylines.map = nil
        self.timer = nil
        self.timerCountDown = nil
        self.timer?.invalidate()
        self.timerCountDown?.invalidate()
        self.count = 0
        self.totalCount = 0
        self.currentCount = 0
    }
    
    @IBAction func btnRefresh(_ sender: Any) {
        
        self.path.removeAllCoordinates()
        self.mapView.clear()
        self.polylines.map = nil
        self.timer = nil
        self.timerCountDown = nil
        self.timer?.invalidate()
        self.timerCountDown?.invalidate()
        self.count = 0
        self.totalCount = 0
        self.currentCount = 0
        startTimer()
    }
    
    
}

